let veiling_name = "1PLXUe9uTlfNXAQeXi6s2sZkjp6YRFbI";

////////////////////////////////////////////////////////////////////////
/////////////////        TODAY TEMPERATURE         /////////////////////
////////////////////////////////////////////////////////////////////////
if ( $( "#actualGPT" ).length ) {
    loadButtonContext();
}

function loadButtonContext(){
    $.ajax({
        method: "GET",
        url: "https://publisher-gat-2.vantago.com/temperature/today/" + veiling_name,
        contentType: 'application/json',
        success: function (data) {
            if (typeof data !== 'string') {
                let date = moment(new Date(data.date)).format("DD.MM.YYYY");
                $("#actualGPT").text(data.customerName + " Gasprognosetemperatur: " + date + " " + data.gat + "°C");
            } else {
                let date = moment(new Date()).format("DD.MM.YYYY");
                $("#actualGPT").text("Es liegt keine GPT für den " + date + " vor");
            }
        }
    }).fail(function () {
        let date = moment(new Date()).format("DD.MM.YYYY");
        $("#actualGPT").text("Es liegt keine GPT für den " + date + " vor");
    });
}

////////////////////////////////////////////////////////////////////////
////////////////////////        DOWNLOAD         ///////////////////////
////////////////////////////////////////////////////////////////////////
if($("#GPTRangeDownload").length ) {
    $("#GPTRangeDownload").daterangepicker({
        "locale": {format: "DD.MM.YYYY"},
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 2000,
        maxYear: parseInt(moment().format('YYYY'), 10)
    });

    $("#GPTDownload").click(function () {
        let fromDate = new Date($("#GPTRangeDownload").data('daterangepicker').startDate._d);
        downloadCSV(fromDate)
    });

    function downloadCSV(fromDate) {
      $.ajax({
            method: "GET",
            url: "https://publisher-gat-2.vantago.com/temperature/future/" + veiling_name + "/byDate/" + fromDate.toISOString().split('T')[0],
            contentType: 'application/json',
            success: function (data) {
                let rows = [["Date", "GAT"]];
                let subrow = [];

                data.forEach(element => {
                    for (const [key, value] of Object.entries(element)) {
                        if (key === "date" || key === "gat") {
                            subrow.push(value);
                        }
                    }
                    rows.push(subrow);
                    subrow = [];
                });

                let csvContent = "data:text/csv;charset=utf-8,"+ rows.map(e => e.join(";")).join("\n");

                var encodedUri = encodeURI(csvContent);
                var link = document.createElement("a");
                link.setAttribute("href", encodedUri);
                link.setAttribute("download", "GAT " + fromDate.toLocaleDateString() + ".csv");
                document.body.appendChild(link);
                link.click();

                document.body.removeChild(link);
            }
        }).fail(function () {
            alert("Server nicht erreichbar, bitte versuchen Sie es zu einem Späteren Zeitpunkt erneut.");
        });
    }
}
